function logbetaf=logbetadensity(xf,y,wconf,thetariskt,clusteralloct,betaconft2,iforbetaconft)
% This function calculates the full conditional density of betaconf

logbetaf=zeros(1,size(xf,2));

vectorfortheta=thetariskt(clusteralloct);

for ixf=1:size(xf,2)

prior=normpdf(xf(ixf),0,1.8); % this gives (almost) flat density from 0 to 1

betaconft2(iforbetaconft,1)=xf(ixf);

vectorforsum=(y'.*((vectorfortheta+betaconft2'*wconf')-...
    log(1+exp(vectorfortheta+betaconft2'*wconf'))))...
    +((1-y').*(-log(1+exp(vectorfortheta+betaconft2'*wconf'))));


logbetaf(1,ixf)=sum(vectorforsum)+log(prior);
end   